--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar: Quests Menu
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------

local xDialog = gDialogTable.x or 0
local yDialog = gDialogTable.y or 0

local menu = {}
local x=0
local y=0

table.insert(menu, DevMenuItem { x=x,y=y, w=150, label="#-CLOSE-", close=true })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=x,y=y, w=150, label="#RELOAD STRINGS", command=function() LQuest:ReloadStringTable() CloseWindow() end })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=x,y=y, w=150, label="#RESET QUESTS", command=function() gSim:InitQuests() LQuest:ResetAll() CloseWindow() end })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=x,y=y, w=150, label="#QUEST VARIABLES", command=function() DisplayDialog { "dev/devquestvars.lua", x=xDialog+150,y=yDialog } end })
y = y + bsgFontHeight(devfont) + 2

local completedFont = { devfont[1], devfont[2], Color(0,0,0,255) }
local ineligibleFont = { devfont[1], devfont[2], Color(32,32,192,255) }

for quest in LQuest:AllQuests() do
	local q = quest
	
	local n = q:NameText() or q.name
	n = "#"..n

	local font = devfont
	if q.complete then font = completedFont
	elseif not q:IsEligible() then font = ineligibleFont
	end

	table.insert(menu, DevMenuItem { x=x,y=y, w=150, label=n, name=q.name, font=font,
		command=function() DisplayDialog { "dev/devquest.lua", quest=q, x=xDialog+150,y=yDialog } end })
	y = y + bsgFontHeight(devfont) + 2
	if y > ui.devScreenHeight - 30 then
		y = 0
		x = x + 150
	end
end

-------------------------------------------------------------------------------


MakeDialog
{
	Rectangle
	{
		x=xDialog,y=yDialog, color=devBackgroundColor, alpha=devAlpha, inset=3,
		Group(menu),
	}
}
